#include "ringset_control.h"

/*
 * ringset_control_setup
 *
 *	This function is declared in ringset_control.h
 */
void ringset_control_setup(p_smx_dll_simulation_context context_p, p_smx_dll_device device_p) {
	
	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	p_ringset_control_default_pointers
		default_pointers_p = NULL;

#ifdef _DEBUG
	//	if( IsDebuggerPresent() ) {
	//		DebugBreak();
	//	}
#endif

	// assign default pointers
	if( SMX_DLL_NO_ERROR != ( rv = ringset_control_assign_default_pointers( context_p, device_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Error occurred during ringset_control_assign_default_pointers." );
	}

	// cast default pointers
	default_pointers_p = (p_ringset_control_default_pointers)device_p->unmanaged_user_storage;

	// check that mins are not greater than maxes, lest the universe explode
	if( default_pointers_p->parameter_values_p->RSET_MIN_LL > default_pointers_p->parameter_values_p->RSET_MAX_LL ) {
		context_p->funcs->fatal_error( device_p, "Parameter value error: RSET_MIN_LL > RSET_MAX_LL." );
	}
	if( default_pointers_p->parameter_values_p->RSET_MIN_HL > default_pointers_p->parameter_values_p->RSET_MAX_HL ) {
		context_p->funcs->fatal_error( device_p, "Parameter value error: RSET_MIN_HL > RSET_MAX_HL." );
	}

}
