#include "counter_with_increment.h"

/*
 * counter_with_increment_set_initial_condition_single_output_from_IC_parameter
 *
 * This function will take the value of the IC parameter and write it to
 *	the output bus. 
 *
 * This function assumes that the setup routine called counter_with_increment_assign_default_pointers, so the function
 *	counter_with_increment_set_initial_condition should not. 
 */
SMX_DLL_ERROR counter_with_increment_set_initial_condition_single_output_from_IC_parameter(
	p_smx_dll_simulation_context context_p
	,
	p_smx_dll_device device_p
){

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	s_smx_dll_bus_conversion
		conversion;

	p_counter_with_increment_default_pointers
		default_pointers_p = NULL;

	// cast unmanaged user storage
	default_pointers_p = (p_counter_with_increment_default_pointers)device_p->unmanaged_user_storage;

	// bus conversion type
	conversion.type = SMX_DLL_TYPE_8BIT;

	// bus conversion encoding
	conversion.encoding = SMX_DLL_ENCODING_UNSIGNED;

	// bus conversion value
	conversion.ubyte8 = (SMX_DLL_UBYTE8)default_pointers_p->parameter_values_p->IC;

	// write initial condition to output bus
	rv = context_p->funcs->write_bus( default_pointers_p->output_bus_pointers_p->OUT_bus_p, &( conversion ), SMX_DLL_WRITE_INITIAL_CONDITION );

	return rv;

}

/*
 * counter_with_increment_set_initial_condition
 *
 *	This function is declared in counter_with_increment.h
 */
void counter_with_increment_set_initial_condition(p_smx_dll_simulation_context context_p, p_smx_dll_device device_p) {

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	SMX_DLL_UBYTE8
		*pending_output = NULL;

	p_counter_with_increment_default_pointers
		default_pointers_p = NULL;

	// assign initial condition
	if( SMX_DLL_NO_ERROR != ( rv = counter_with_increment_set_initial_condition_single_output_from_IC_parameter( context_p, device_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Error occurred during counter_with_increment_set_initial_condition_single_output_from_IC_parameter." );
	}

	// cast unmanaged user storage
	default_pointers_p = (p_counter_with_increment_default_pointers)device_p->unmanaged_user_storage;

	// cast user storage pointer
	pending_output = (SMX_DLL_UBYTE8*)device_p->user_storage;

	// assign initial pending output
	*pending_output = (SMX_DLL_UBYTE8)default_pointers_p->parameter_values_p->IC;

}
