#ifndef VARIABLE_FREQUENCY_DIGITAL_SOURCE_H
#define VARIABLE_FREQUENCY_DIGITAL_SOURCE_H

#include "smx_dll.h"

#ifdef __cplusplus
	extern "C" {
#endif

// begin customization
#define VARIABLE_FREQUENCY_DIGITAL_SOURCE_INITIAL_SETUP 1234567890
// end customization

__declspec(dllexport) p_smx_dll_device_spec* smx_dll_get_supported_devices(void);
__declspec(dllexport) p_smx_dll_device_spec  smx_dll_get_device_spec(char* name, SMX_DLL_UINT32 version);

typedef struct t_variable_frequency_digital_source_input_bus_pointers {

	p_smx_dll_bus BASE_bus_p;
	p_smx_dll_bus EXPONENT_bus_p;
	p_smx_dll_bus READY_bus_p;

} s_variable_frequency_digital_source_input_bus_pointers, *p_variable_frequency_digital_source_input_bus_pointers;

typedef struct t_variable_frequency_digital_source_output_bus_pointers {

	p_smx_dll_bus OUT_bus_p;

} s_variable_frequency_digital_source_output_bus_pointers, *p_variable_frequency_digital_source_output_bus_pointers;

typedef struct t_variable_frequency_digital_source_parameter_values {

	SMX_DLL_UINT64 IC;
	SMX_DLL_DOUBLE DELAY;
	SMX_DLL_DOUBLE DUTY_CYCLE;

} s_variable_frequency_digital_source_parameter_values, *p_variable_frequency_digital_source_parameter_values;

typedef struct t_variable_frequency_digital_source_default_pointers {

	p_variable_frequency_digital_source_input_bus_pointers	input_bus_pointers_p;
	p_variable_frequency_digital_source_output_bus_pointers	output_bus_pointers_p;
	p_variable_frequency_digital_source_parameter_values	parameter_values_p;

	// begin customization
	p_smx_dll_pin
		READY_pin_p;
	p_smx_dll_pin
		OUT_pin_p;
	// end customization

} s_variable_frequency_digital_source_default_pointers, *p_variable_frequency_digital_source_default_pointers;

// begin customization
typedef struct t_variable_frequency_digital_source_managed_storage {

	SMX_DLL_UINT32
		frequency;
	SMX_DLL_UBYTE8
		exponent;
	SMX_DLL_UINT64
		active_identifier;
	SMX_DLL_DOUBLE
		period;

} s_variable_frequency_digital_source_managed_storage, *p_variable_frequency_digital_source_managed_storage;
// end customization

/*
 * variable_frequency_digital_source_setup
 *
 *	This function is defined in variable_frequency_digital_source_setup.c
 */
void
	variable_frequency_digital_source_setup(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * variable_frequency_digital_source_set_initial_condition
 *
 *	This function is defined in variable_frequency_digital_source_set_initial_condition.c
 */
void
	variable_frequency_digital_source_set_initial_condition(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * variable_frequency_digital_source_action
 *
 *	This function is defined in variable_frequency_digital_source_action.c
 */
void
	variable_frequency_digital_source_action(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * variable_frequency_digital_source_teardown
 *
 *	This function is defined in variable_frequency_digital_source_teardown.c
 */
void
	variable_frequency_digital_source_teardown(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * variable_frequency_digital_source_assign_default_pointers
 *
 *	This function is defined in smx_dll.c
 */
SMX_DLL_ERROR
	variable_frequency_digital_source_assign_default_pointers(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
	);

/*
 * variable_frequency_digital_source_instantiate_default_pointers
 *
 *	This function is defined smx_dll.c
 */
SMX_DLL_ERROR
	variable_frequency_digital_source_instantiate_default_pointers(
		p_smx_dll_simulation_context context_p
		,
		p_smx_dll_device device_p
		,
		p_variable_frequency_digital_source_default_pointers *result
	);

#ifdef __cplusplus
}
#endif

#endif
